#version 430 core

layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;

layout (location = 3) in uvec4 firstBoneIDs;
layout (location = 4) in vec4 firstBoneWeights;
layout (location = 5) in ivec3 instanceID;

layout(location = 0) out vec3 fragViewNormal;


uniform int modelID;
uniform int BoneCount; 


layout(binding = 0, rgba32f) uniform readonly restrict image2D inputTex;
layout(binding = 1, rgba32f) uniform readonly restrict image2D noiseTex;

mat4 getBone(uint boneID, uint instanceNumber){

	mat4 newMat;

		newMat[0] = vec4(imageLoad(inputTex, ivec2(20 + 4*boneID, instanceNumber)));
    newMat[1] = vec4(imageLoad(inputTex, ivec2(21 + 4*boneID, instanceNumber)));
    newMat[2] = vec4(imageLoad(inputTex, ivec2(22 + 4*boneID, instanceNumber)));
    newMat[3] = vec4(imageLoad(inputTex, ivec2(23 + 4*boneID, instanceNumber)));

	return newMat;

}


void main()
{

	int instanceNumber = gl_InstanceID;

	mat4 lightSpaceModel;

	lightSpaceModel[0] = vec4(imageLoad(inputTex, ivec2(8, instanceNumber)));
  lightSpaceModel[1] = vec4(imageLoad(inputTex, ivec2(9, instanceNumber)));
  lightSpaceModel[2] = vec4(imageLoad(inputTex, ivec2(10, instanceNumber)));
  lightSpaceModel[3] = vec4(imageLoad(inputTex, ivec2(11, instanceNumber)));


	int boneID = int(firstBoneIDs.x);
	float scalingFactor = 1.0;

	scalingFactor = imageLoad(noiseTex, ivec2(boneID, instanceID)).y;

	vec4 worldPos = vec4(position * scalingFactor, 1.0);

	mat4 transformMatrix = mat4(1.0);
	
	if (BoneCount > 0){

	transformMatrix = firstBoneWeights.x * getBone(firstBoneIDs.x, instanceNumber);
	transformMatrix += firstBoneWeights.y * getBone(firstBoneIDs.y, instanceNumber);
	transformMatrix += firstBoneWeights.z * getBone(firstBoneIDs.z, instanceNumber);
	transformMatrix += firstBoneWeights.w * getBone(firstBoneIDs.w, instanceNumber);

	}
	
	mat3 normalMatrix = transpose(inverse(mat3(lightSpaceModel * transformMatrix)));
  fragViewNormal = normalMatrix * normal;

	
	vec3 fragViewPos = (lightSpaceModel * transformMatrix * worldPos).xyz;
	
	gl_Position = vec4(fragViewPos, 1.0);
} 